/*
 * Help texts for the ProofPower X/Motif Interface.
 * This file is automatically created from help.txt by the script makehelp.sh
 * Do not edit.
 */
#define _help
#include "xpp.h"
const String Help_About_Xpp =
"==== About Xpp ====\n"
"\n"
"Welcome to Xpp - the ProofPower X/Motif Interface.\n"
"\n"
"Xpp provides a convenient way to prepare, check and execute\n"
"ProofPower scripts.  It combines a general purpose text\n"
"editor with a command interface for operating the ProofPower\n"
"system.\n"
"\n"
"Copyright (C) Lemma 1 Ltd. 2000-2017.\n"
"\n"
;
const String Help_Using_Help =
"==== Using Help ====\n"
"\n"
"Help is available from the Help menu in the Main Window and\n"
"from the Help push-buttons in other windows in xpp.\n"
"\n"
"You can dismiss this Help Window when you have finished by\n"
"clicking on the push-button labelled Dismiss. You do not\n"
"need to dismiss the Help Window before using other parts of\n"
"xpp; instead you can resize or move the window, if\n"
"necessary, to prevent it obscuring what you want to work on\n"
"and then carry on as normal.\n"
"\n"
"If you are unfamiliar with using Motif or similar\n"
"applications, the Tutorial item in the Main Window Help menu\n"
"contains information which will help you make a start. You\n"
"may also wish to consult your local user documentation for\n"
"Motif, which will give further information on keyboard\n"
"shortcuts etc.\n"
"\n"
"Use the vertical scroll bar to the side of the help text to\n"
"move around in the text.  The simplest way to do this is to\n"
"use the triangular arrows at the top and bottom of the\n"
"scroll-bar.  Click Button 1 (usually the left mouse button)\n"
"on the bottom arrow to move down, and on the top arrow to\n"
"move up.  Many keyboards have PageUp and PageDown keys or\n"
"arrow keys which can also be used to move around in a text\n"
"area like this one.  You may have to click button 1 on the\n"
"help window first to get this to work.\n"
"\n"
;
const String Help_Tutorial =
"==== Tutorial ====\n"
"\n"
"This help text introduces the more important features of\n"
"xpp.\n"
"\n"
"The Motif look and feel which xpp supports offers many\n"
"shortcuts, and only a few of the more useful techniques are\n"
"mentioned below.  Consult your local Motif user\n"
"documentation or just experiment to find out more.\n"
"\n"
"--- Starting Xpp ---\n"
"\n"
"Use a UNIX command line like one of the following to begin a\n"
"session with xpp:\n"
"\n"
"        xpp myfile.doc\n"
"\n"
"        xpp myfile.doc -d example_hol\n"
"\n"
"        xpp -display server1:0 myfile.doc -d example_hol\n"
"\n"
"The line without the `-d' gives an xpp session running the\n"
"editor only on file `myfile.doc'.  The other two command\n"
"lines give the command interface as well and use it to start\n"
"an interactive ProofPower session (invoked as `pp -d\n"
"example_hol').\n"
"\n"
"Edit-only and command interface sessions with xpp are very\n"
"similar.  The edit-only sessions have a subset of the\n"
"features of the command interface.\n"
"\n"
"--- Main Window ---\n"
"\n"
"In a command interface session, the xpp Main Window has four\n"
"main areas as follows:\n"
"\n"
"Menu Bar       This contains menus which you use to select\n"
"               the main editing and ProofPower command\n"
"               functions.  There are items in the Help Menu\n"
"               to give more information on each of these\n"
"               menus.\n"
"\n"
"File Name Bar  This contains the name of the file from which\n"
"               the script you are editing comes.  It also\n"
"               tells you when you have made changes to the\n"
"               script and shows the line number of the\n"
"               current insertion position in script.\n"
"\n"
"Script Window  This is the Motif text area in which the\n"
"               script is entered and edited.  This offers a\n"
"               general purpose editor whose features are\n"
"               described later in this help text.\n"
"\n"
"Journal Window This displays a journal of your transactions\n"
"               with ProofPower.  The basic technique for\n"
"               executing a ProofPower command is to select\n"
"               some text in the Script Window and then use\n"
"               Execute Selection from the Command Menu.\n"
"\n"
"In an edit-only session, there are only three areas in the\n"
"Main Window: the Journal Window does not appear.\n"
"\n"
"--- Mouse Buttons ---\n"
"\n"
"Xpp works with a mouse or other pointing device with two or\n"
"three buttons.\n"
"\n"
"Button 1 This is usually the left button and is sometimes\n"
"         labelled `SELECT'.  It is often used for making\n"
"         selections, and for activating menus, menu items\n"
"         and push-buttons.\n"
"\n"
"Button 2 With a three-button mouse, this is usually the\n"
"         centre button and is sometimes labelled `ADJUST' or\n"
"         `TRANSFER'.  With a two-button mouse, pressing this\n"
"         button is usually emulated by pressing both buttons\n"
"         together.  Button 2 is often used to copy and move\n"
"         text.  It is also used, e.g., in scroll bars, in a\n"
"         similar way to Button 1 but sometimes with a\n"
"         different effect.\n"
"\n"
"Button 3 This is usually the right button. It is used in the\n"
"         text windows to pop up the Edit Menu.\n"
"\n"
"You may like to experiment with mouse buttons 1 and 2 in the\n"
"scroll bar for this help text to see how they differ.\n"
"\n"
"--- Paned Windows ---\n"
"\n"
"Some windows which xpp provides comprise several resizable\n"
"elements stacked vertically or horizontally.  The elements\n"
"of these `paned' windows may be separated by a line with a\n"
"small square button, called a `sash'.  The Search and\n"
"Replace Tool is an example of a paned window.\n"
"\n"
"You can resize a resizable element in a paned window by\n"
"holding Button 1 down over the sash and dragging it up or\n"
"down.\n"
"\n"
"--- Text Areas ---\n"
"\n"
"Xpp provides a number of text areas in which you can enter\n"
"and edit text.  The most important of these is the Script\n"
"Window (the uppermost or rightmost large text area in the\n"
"main window).  There are also text areas like this Help Text\n"
"and the Journal Window in which xpp displays information but\n"
"which are read-only: you cannot enter text into them\n"
"directly. You can usually copy text out of these read-only\n"
"text areas using some of the techniques described under\n"
"`Operations on Text Selections' below.\n"
"\n"
"In conjunction with the File Menu, the Edit Menu and the\n"
"tools provided by the Tools Menu, the Script Window provides\n"
"a general purpose text editor.\n"
"\n"
"Text areas also feature in other windows such as the Search\n"
"and Replace Tool, in which you can type search and replace\n"
"patterns, and the File Selection Box in which you can type\n"
"in file names.  Basic typing and editing operations are\n"
"similar in all of the text areas.  In most text areas, you\n"
"can use Button 3 to bring up the popup Edit Menu.\n"
"\n"
"--- Entering Text ---\n"
"\n"
"To insert text, click Button 1 on the point at which you\n"
"want the text to begin.  A thin vertical line (called the I-\n"
"beam cursor) will flash at the insertion point you have\n"
"selected.  You can now type at the keyboard to enter text.\n"
"\n"
"The simplest way to correct mistakes is to use the Backspace\n"
"key or the Delete key.  The Backspace key deletes the\n"
"character just before the I-beam cursor and the Delete key\n"
"deletes the one just after it.\n"
"\n"
"Mathematical and other symbols may also be entered, using\n"
"the Palette Tool and the Template Tool very much as if you\n"
"had typed them at the keyboard.  See the help item for the\n"
"Tools Menu for more information on these tools.\n"
"\n"
"--- Undoing Text Changes ---\n"
"\n"
"Undo in the Edit Menu can be used to correct errors.  Undo\n"
"will undo the effect of all the typing you did since you\n"
"last started typing at a new insertion point.\n"
"\n"
"You can reverse the effect of an Undo, by selecting Redo\n"
"from the Edit Menu.\n"
"\n"
"--- Making Text Selections ---\n"
"\n"
"You generally carry out more complex editing operations\n"
"which operate on a block of text by first selecting the text\n"
"to operate on.  To select some text press Button 1 down at\n"
"one end of the text you want to select, then, holding the\n"
"button down, drag the pointer to the other end of the\n"
"selection and release the button.  The selected text will\n"
"become highlighted.\n"
"\n"
"When you have made a selection you can grow or shrink it by\n"
"holding down the Shift key and clicking Button 1 where you\n"
"want the new end-point to be.\n"
"\n"
"You can quickly select a word or a line by double- or\n"
"triple-clicking, but quadruple clicking does not select the\n"
"entire text.  The entire text can quickly be selected using\n"
"the keyboard by pressing the `/' key while holding the\n"
"Control key down.\n"
"\n"
"--- Operations on Text Selections ---\n"
"\n"
"Having made a selection there are several things you can do\n"
"with the selected text. Some of the more common ones use the\n"
"Clipboard: an off-screen area where text can be stored.\n"
"Motif defines three keys that are often used to work with\n"
"the Clipboard: the Copy, Cut and Paste keys. If your\n"
"keyboard does not have these keys, they can usually be\n"
"emulated: typically, Copy is <Ctrl><Insert>, Cut is\n"
"<Shift><Delete>, and Paste is <Shift><Insert>.  You can also\n"
"carry out these functions in most text areas in xpp by using\n"
"Button 3 to bring up the popup Edit Menu and in the Script\n"
"Window using the Edit Menu in the Menu Bar.\n"
"\n"
"You can retrieve text from the Clipboard by clicking Button\n"
"1 to select the point where you want the text to appear and\n"
"then pressing the Paste key.\n"
"\n"
"Some other useful operations on selections are:\n"
"\n"
"Delete            Press the Backspace key or the Delete key\n"
"                  and the whole selection will be deleted.\n"
"\n"
"Overtype          Type at the keyboard and what you type\n"
"                  will replace the selection.\n"
"\n"
"Copy to Clipboard Press the Copy key and the selection will\n"
"                  be copied into an off-screen area called\n"
"                  the Clipboard.\n"
"\n"
"Cut to Clipboard  Press the Cut key to combine the effects\n"
"                  of Copy and Delete: Cut deletes the text\n"
"                  while also copying it to the Clipboard.\n"
"\n"
"Quick Copy        Move the pointer away from the selection\n"
"                  then press Button 2, and the text will be\n"
"                  copied to the new pointer position.  This\n"
"                  lets you copy the selection from one text\n"
"                  area to another, or within one text area\n"
"                  without using the Clipboard.\n"
"\n"
"Motif text areas provide several other operations with\n"
"selections.  Consult your local Motif user documentation for\n"
"further information.\n"
"\n"
"--- Customising xpp ---\n"
"\n"
"You can customize many aspects of the appearance and\n"
"behaviour of xpp by adjusting settings (called `resources')\n"
"held in the files app-defaults/Xpp, app-defaults/XppKeyboard\n"
"and app-defaults/XppTemplates, either in the ProofPower\n"
"installation directory or in your home directory. Note that\n"
"these files are only read when xpp starts: so you need to\n"
"start a new session for any changes you make to have effect.\n"
"Please consult the Xpp User Guide for more information on\n"
"customizing xpp.\n"
"\n"
;
const String Help_File_Menu =
"==== File Menu ====\n"
"\n"
"This menu is used to save the text in the Script Window into\n"
"a file or to read a file in. It is also used to finish an\n"
"editing session.\n"
"\n"
"The commands in this menu ending in `...' bring up a File\n"
"Selection Box which you use to choose the name of a file to\n"
"work on.  The other commands either do not need a file name\n"
"or work on the file whose name appears in the File Name Bar.\n"
"\n"
"The commands will ask for confirmation before taking any\n"
"action which could lose your work.\n"
"\n"
"Save                    saves all the text into the file\n"
"                        named in the File Name Bar.\n"
"\n"
"Save As ...             saves all the text into a file that\n"
"                        you choose and puts the name of the\n"
"                        file in the File Name Bar for future\n"
"                        reference.\n"
"\n"
"Save Selection As ...   saves the text you have selected\n"
"                        (e.g. by holding down Button 1 and\n"
"                        dragging) into a file that you\n"
"                        choose.  This does not change the\n"
"                        file named in the File Name Bar.\n"
"\n"
"Open ...                opens a file that you choose and\n"
"                        puts the name of the file in the\n"
"                        File Name Bar for future reference.\n"
"\n"
"Include ...             copies text in from a file that you\n"
"                        choose; the text is copied in just\n"
"                        after the I-beam cursor in the\n"
"                        Script Window; the file named in the\n"
"                        File Name Bar does not change.\n"
"\n"
"Revert                  is just like opening the file whose\n"
"                        name is in the File Name Bar; this\n"
"                        is often useful for undoing a large\n"
"                        batch of unintended changes.\n"
"\n"
"Empty File              discards any text in the Script\n"
"                        Window and puts a dummy name into\n"
"                        the File Name Bar.\n"
"\n"
"Reopen                  brings up a pull-right menu listing\n"
"                        the files you have previously been\n"
"                        editing.  This menu item will be\n"
"                        greyed out from when you first start\n"
"                        xpp until you open a new file or\n"
"                        save the current file under a new\n"
"                        name.\n"
"\n"
"New Session             is a pull-right menu that can be\n"
"                        used to start up a new xpp editor or\n"
"                        command session.\n"
"\n"
"Quit                    finishes your editing session.\n"
"\n"
;
const String Help_Edit_Menu =
"==== Edit Menu ====\n"
"\n"
"This menu is used for the following editing functions, some\n"
"of which operate on the Clipboard (a means of passing text\n"
"around between applications or within one application).\n"
"\n"
"Cut                     moves the text you have selected out\n"
"                        of your script to the Clipboard.\n"
"\n"
"Copy                    copies the text you have selected to\n"
"                        the Clipboard. This doesn't change\n"
"                        the script.\n"
"\n"
"Paste                   copies the text on the Clipboard\n"
"                        into your document.\n"
"\n"
"Undo                    undoes the last editing operation\n"
"                        you carried out.\n"
"\n"
"Redo                    reverses an undo.\n"
"\n"
"Search and Replace ...  brings up a tool which lets you\n"
"                        search for a pattern in your script,\n"
"                        and if you wish, replace some or all\n"
"                        instances of the pattern with some\n"
"                        other text.\n"
"\n"
"Goto Line ...           brings up a tool which lets you\n"
"                        navigate round the script using line\n"
"                        numbers.\n"
"\n"
;
const String Help_Tools_Menu =
"==== Tools Menu ====\n"
"\n"
"This menu is used to start up various tools which run in\n"
"windows of their own.\n"
"\n"
"Palette    brings up a tool containing a palette of\n"
"           mathematical and other symbols.  The palette is\n"
"           an array of push-buttons; pressing a push-button\n"
"           inserts the character into the text you are\n"
"           currently editing.\n"
"\n"
"Templates  is used for easy entry of constructs such as Z\n"
"           paragraphs.  The templates tool is an array of\n"
"           push-buttons; pressing a push-button inserts a\n"
"           sequence of characters into your script\n"
"           corresponding to the symbol drawn on it, as if\n"
"           you had typed the characters in at the keyboard.\n"
"           This menu item may be greyed out (see note\n"
"           below).\n"
"\n"
"Options    brings up a tool which lets you adjust various\n"
"           settings which affect the behaviour of xpp.  For\n"
"           example, you can say whether or not you want the\n"
"           editor to take a back up of a file before\n"
"           overwriting it when you use the save command in\n"
"           the file menu.\n"
"\n"
"Note: the Templates Tool is set up from the applications\n"
"defaults file for xpp (e.g. see the ProofPower Reference\n"
"Manual entry for xpp).  The Templates menu item will be\n"
"greyed out, and the Templates Tool will not be available, if\n"
"the applications defaults file does not contain an\n"
"appropriate setting for the `templates' resource.\n"
"\n"
;
const String Help_Window_Menu =
"==== Window Menu ====\n"
"\n"
"This menu helps you work with the layout and geometry of the\n"
"main window.\n"
"\n"
"Show Geometry      brings up a tool showing you the geometry\n"
"                   of the script window.  In a command\n"
"                   session, the tool also shows the geometry\n"
"                   of the journal window and the settings to\n"
"                   use in the applications default file to\n"
"                   give the current layout and geometry.\n"
"\n"
"The remaining items are only available in command sessions.\n"
"\n"
"Show/hide Script   hides the script window if it is\n"
"                   displayed or displays both the script and\n"
"                   journal windows if either of them is\n"
"                   hidden.\n"
"\n"
"Show/hide Journal  hides the journal window if it is\n"
"                   displayed or displays both the script and\n"
"                   journal windows if either of them is\n"
"                   hidden.\n"
"\n"
"Toggle Geometry    switches between the vertical and\n"
"                   horizontal layouts for the script and\n"
"                   journal windows.\n"
"\n"
;
const String Help_Command_Menu =
"==== Command Menu ====\n"
"\n"
"You can use this menu to pass commands to ProofPower, if you\n"
"are running a command interface session of xpp (i.e., you\n"
"have specified a `-command' argument on the command line).\n"
"This menu is not provided in an edit-only session.\n"
"\n"
"Xpp will prompt you if the effect of a menu item is likely\n"
"to lose some of your work.\n"
"\n"
"The menu items work as follows:\n"
"\n"
"Command Line       invokes a tool for running ProofPower\n"
"                   commands which you do not want to have in\n"
"                   your script.\n"
"\n"
"Execute Selection  sends the text you have selected to be\n"
"                   executed as a ProofPower command.\n"
"                   Depending on a setting you can adjust\n"
"                   with the Options Tool, a carriage return\n"
"                   character may be sent after the text, if\n"
"                   it does not already end with one.\n"
"\n"
"Return             sends a carriage return character.\n"
"\n"
"Semicolon          sends a semicolon followed by a carriage\n"
"                   return character.  This is often\n"
"                   convenient for finishing off lines of\n"
"                   Standard ML.\n"
"\n"
"Abandon            gives a convenient way of abandoning a\n"
"                   ProofPower computation.  It sends an\n"
"                   interrupt signal and then waits for a\n"
"                   prompt from ProofPower; when the prompt\n"
"                   is received it replies with a command to\n"
"                   cause ProofPower to abandon what it is\n"
"                   currently executing.\n"
"\n"
"Interrupt          sends an interrupt signal.\n"
"\n"
"Kill               sends a kill signal.  This will cause the\n"
"                   ProofPower session to be terminated and\n"
"                   will lose any work which you have not\n"
"                   saved.\n"
"\n"
"Restart            restarts the ProofPower session.  This\n"
"                   will cause the current ProofPower session\n"
"                   to be terminated and will lose any work\n"
"                   which you have not saved.\n"
"\n"
;
const String Help_File_Name_Bar =
"==== File Name Bar ====\n"
"\n"
"The File Name Bar displays information about the file you\n"
"are editing. From left to right, it provides the following\n"
"information:\n"
"\n"
"File Name     This tells you the name of the file.\n"
"\n"
"Status Label  This indicates: whether the file is new (i.e.,\n"
"              does not exist in the file system yet); what\n"
"              the file type is, if other than Unix; whether\n"
"              you have modified the file; and whether the\n"
"              file is read only.  If none of these apply,\n"
"              then the status label is blank.\n"
"\n"
"Line Number   This gives the line number of the current\n"
"              insertion position, i.e., the position in the\n"
"              file at which the next character you type\n"
"              would be inserted. Right-clicking on the line\n"
"              number brings up a menu letting you start or\n"
"              stop the line number indicator.\n"
"\n"
;
const String Help_Search_and_Replace_Tool =
"==== Search and Replace Tool ====\n"
"\n"
"You can use this tool to search for patterns in the Script\n"
"Window.  It also lets you replace some or all occurrences of\n"
"a pattern with replacement text .\n"
"\n"
"The tool provides a number of push-buttons and two text\n"
"areas.  There are also two toggle buttons that you can use\n"
"to control the interpretation of search patterns.  The upper\n"
"text area is where you enter the search pattern.  The lower\n"
"text area is for the replacement text for use in replace\n"
"operations.  See below for more information about the\n"
"interpretation of the replacement text.\n"
"\n"
"Clicking button 3 in either of the text areas gives you the\n"
"popup Edit Menu which carries out the standard editing\n"
"operations and also lets you empty the text area or replace\n"
"its contents by the current selection.\n"
"\n"
"The push-buttons work as follows:\n"
"\n"
"<= Search       starts a `backwards' search: it looks for\n"
"                the first occurrence of the search pattern\n"
"                before the I-beam cursor in the Script\n"
"                Window.  If the pattern is found, it will be\n"
"                selected (highlighted) in the Script Window.\n"
"\n"
"Search =>       starts a `forwards' search: it looks for the\n"
"                first occurrence of the pattern after the\n"
"                cursor.\n"
"\n"
"Replace         causes the current selection in the Script\n"
"                Window to be replaced by the contents of the\n"
"                replacement text area.\n"
"\n"
"Replace All     causes all occurrences of the search pattern\n"
"                to be replaced by the replacement text.\n"
"\n"
"Replace & <=    like `Replace' followed by `<= Search'.\n"
"\n"
"Replace & =>    like `Replace' followed by `Search =>'.\n"
"\n"
"Dismiss         hides the Search and Replace Tool from view.\n"
"                You can bring it back by selecting the\n"
"                Search and Replace item in the Edit Menu\n"
"                again.\n"
"\n"
"Help            displays this help text.\n"
"\n"
"Using the toggle buttons, you can choose how xpp interprets\n"
"search patterns.  The choices are whether or not searches\n"
"should ignore the case of letters (treating `a' and `A' as\n"
"equivalent etc.) and whether or not patterns should be\n"
"treated as regular expressions containing wildcards (e.g.,\n"
"treating 'AB*' as matching an 'A' followed by any number of\n"
"'B's).\n"
"\n"
"When you use wildcards the replacement text in replace\n"
"operations is interpreted specially: the text matching the\n"
"pattern is substituted for each unescaped occurrence of '&'\n"
"in the replacement text; backslash is used as the escape\n"
"character.\n"
"\n"
"When you do a search, xpp stores information about the\n"
"search in registers numbered 0, 1, ... and 9.  Register 0\n"
"holds the entire matched text while registers 1, 2, ... and\n"
"9 hold the text that matched the first, second, ... and\n"
"ninth bracketed subexpression of the pattern.  The\n"
"subexpressions are numbered by counting the opening brackets\n"
"from left to right in the pattern.  The replacement\n"
"registers can be accessed in your replacement text using an\n"
"escaped digit.\n"
"\n"
"The wildcards conform to the POSIX extended regular\n"
"expression syntax, which is documented in the regex(7)\n"
"manual page on most systems.  There is a summary in the Xpp\n"
"User Guide.\n"
"\n"
;
const String Help_Line_Number_Tool =
"==== Line Number Tool ====\n"
"\n"
"You can use this tool to navigate around the text using line\n"
"numbers.\n"
"\n"
"The tool provides a number of push-buttons and a text area.\n"
"The text area is used to hold a line number.  Clicking\n"
"button 3 in the text area gives you the popup Edit Menu\n"
"which carries out the standard editing operations and also\n"
"lets you replace the line number with the number of the\n"
"current line in the script window.\n"
"\n"
"The push-buttons work as follows:\n"
"\n"
"Goto line       causes the Script Window to move to the line\n"
"                whose number is in the line number area.\n"
"\n"
"Dismiss         hides the Line Number Tool from view. You\n"
"                can bring it back by selecting the Line\n"
"                Number item in the Edit Menu again.\n"
"\n"
"Help            displays this help text.\n"
"\n"
;
const String Help_Palette_Tool =
"==== Palette Tool ====\n"
"\n"
"You can use this tool to enter mathematical symbols into the\n"
"text you are editing very much as if you had typed the\n"
"symbol using the keyboard.  The tool contains an array of\n"
"push-buttons called the palette; pressing a push-button\n"
"inserts the character into the text you are currently\n"
"editing.  The tool keeps track of the text area that has the\n"
"input focus, so for example, if you start typing in the text\n"
"area in the Command Line Tool and then press a palette\n"
"button, the symbol will be entered into that text area.\n"
"\n"
;
const String Help_Options_Tool =
"==== Options Tool ====\n"
"\n"
"You can use this tool to check or alter various settings\n"
"which control the way xpp works.\n"
"\n"
"The tool contains toggle buttons (small square or lozenge\n"
"shaped push-buttons which you operate by pressing with\n"
"Button 1) and, in a command interface session, some text\n"
"fields (in which you can type textual or numeric values).\n"
"\n"
"Commentary is provided alongside each text field or toggle\n"
"button to explain its purpose.\n"
"\n"
"An option controlled by a toggle button is on when the\n"
"button is displayed as pushed in.\n"
"\n"
"The tool also has five push-buttons in a row at the bottom\n"
"which work as follows:\n"
"\n"
"Apply           brings the settings you have entered into\n"
"                force.\n"
"\n"
"Current         puts the settings back to those which are\n"
"                currently in force.\n"
"\n"
"Original        puts the settings back to those which\n"
"                applied when your xpp session was started.\n"
"\n"
"Dismiss         hides the Options Tool from view. You can\n"
"                bring it back by selecting the Options item\n"
"                in the Tools Menu again.\n"
"\n"
"Help            displays this help text.\n"
"\n"
;
const String Help_Command_Line_Tool =
"==== Command Line Tool ====\n"
"\n"
"You can use this tool to execute command lines which you do\n"
"not wish to save in the script you are editing.\n"
"\n"
"The tool comprises three parts:\n"
"\n"
"1   A list which is used to remember commands you wish to\n"
"    execute frequently.  Since the list and the individual\n"
"    commands may be quite long this list has vertical and\n"
"    horizontal scroll bars.  A sample of useful commands is\n"
"    provided when you first bring up the tool.\n"
"\n"
"2   A text area to hold a command line ready for execution.\n"
"    You can type directly into this text area or you can\n"
"    fetch one of the items in the list above by double-\n"
"    clicking on the item you want.  Typing return in this\n"
"    text area causes the command to be executed (as does the\n"
"    Execute push-button).\n"
"\n"
"    The tool maintains a history of the commands that you\n"
"    have executed.  You can use the Page Up and Page Down\n"
"    keys to scroll through this history.  (If this does not\n"
"    work, or if your keyboard does not have Page Up and Page\n"
"    Down keys, you may need to adjust resource settings in\n"
"    your applications defaults file).\n"
"\n"
"3   A row of push-buttons, for use in executing commands,\n"
"    editing the list, etc.\n"
"\n"
"The push-buttons work as follows:\n"
"\n"
"Execute         causes the command in the text area to be\n"
"                executed.\n"
"\n"
"Add             adds the command in the text area to the end\n"
"                of the list.\n"
"\n"
"Delete          removes the selected (highlighted) item from\n"
"                the list.\n"
"\n"
"Dismiss         hides the Command Line Tool from view. You\n"
"                can bring it back by selecting the Command\n"
"                Line item in the Command Menu again.\n"
"\n"
"Help            displays this help text.\n"
"\n"
;
const String Help_File_Selection_Box =
"==== File Selection Box ====\n"
"\n"
"The File Selection Box appears when xpp needs you to tell it\n"
"the name of a file.\n"
"\n"
"The simplest way to use the File Selection Box is just to\n"
"type a file name into Selection text area and then press the\n"
"push-button at the bottom left (labelled with the operation\n"
"in the File Menu which xpp is carrying out).  Xpp will then\n"
"take the name you typed as the name of the file to work\n"
"with.\n"
"\n"
"Pressing the Cancel button dismisses the File Selection Box\n"
"and abandons the file operation xpp was trying to carry out.\n"
"\n"
"It is often convenient to let the File Selection Box help\n"
"you find the file name you want.  If you click on a name in\n"
"the Files list, the name will appear in the Selection and\n"
"you can carry on as if you had just typed it there.\n"
"\n"
"The Filter text area lets you do pattern-matching searches\n"
"for file names.  If you type `/home/me/*' into the Filter\n"
"text area and then press the push-button labelled `Filter',\n"
"the names of all the files in directory `/home/me' will\n"
"appear in the Files list, and all names of all the\n"
"directories in the directory `/home' will appear in the\n"
"Directories list.  If you had typed `/home/me/*.doc' into\n"
"the Filter text area, then only files with names ending in\n"
"`*.doc' would be shown in the Files list.\n"
"\n"
"Clicking on a directory name replaces the directory part of\n"
"the Filter text area with the directory name.\n"
"\n"
"Depending on the xpp command line options, the file\n"
"selection box may appear when xpp starts with an extra text\n"
"field for you to enter the command to run in the Journal\n"
"Window. Simply type in the command you wish to run.\n"
"\n"
;
const String Help_Templates_Tool =
"==== Templates Tool ====\n"
"\n"
"The buttons in the templates tool enter templates for\n"
"language constructs into the Script Window.  The icons and\n"
"their corresponding constructs are as described below:\0\n"
"\n"
;
const String Help_Command_Line_Dialogue =
"==== Command Line Dialogue ====\n"
"\n"
"xpp has been started with the command line specified as an\n"
"empty string.  Please type the command you wish to run into\n"
"the text area and then click OK.\n"
"\n"
"Click Quit to quit this xpp session.\n"
"\n"
"\n";
